/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.colony.jobs;

import com.minecolonies.api.client.render.modeltype.BipedModelType;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.jobs.ModJobs;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.entity.citizen.Skill;
import com.minecolonies.api.research.util.ResearchConstants;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.coremod.colony.jobs.AbstractJobGuard;
import com.minecolonies.coremod.entity.ai.citizen.guard.EntityAIKnight;
import com.minecolonies.coremod.util.AttributeModifierUtils;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class JobKnight
extends AbstractJobGuard<JobKnight> {
    public static final String DESC = "com.minecolonies.coremod.job.Knight";

    public JobKnight(ICitizenData entity) {
        super(entity);
    }

    public EntityAIKnight generateGuardAI() {
        return new EntityAIKnight(this);
    }

    @Override
    public void onLevelUp() {
        if (this.getCitizen().getEntity().isPresent()) {
            AbstractEntityCitizen citizen = this.getCitizen().getEntity().get();
            AttributeModifier healthModLevel = new AttributeModifier("MinecoloniesGuardLevelHealth", (double)(this.getCitizen().getCitizenSkillHandler().getLevel(Skill.Stamina) + 15), AttributeModifier.Operation.ADDITION);
            AttributeModifierUtils.addHealthModifier((LivingEntity)citizen, healthModLevel);
        }
    }

    @Override
    public JobEntry getJobRegistryEntry() {
        return ModJobs.knight;
    }

    @Override
    public String getName() {
        return DESC;
    }

    @Override
    public BipedModelType getModel() {
        return BipedModelType.KNIGHT_GUARD;
    }

    @Override
    public boolean ignoresDamage(@NotNull DamageSource damageSource) {
        if (damageSource.func_94541_c() && this.getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.SHIELD_USAGE) > 0.0 && InventoryUtils.findFirstSlotInItemHandlerWith((IItemHandler)this.getCitizen().getInventory(), Items.field_185159_cQ) != -1) {
            if (!this.getCitizen().getEntity().isPresent()) {
                return true;
            }
            AbstractEntityCitizen worker = this.getCitizen().getEntity().get();
            worker.getCitizenItemHandler().setHeldItem(Hand.OFF_HAND, InventoryUtils.findFirstSlotInItemHandlerWith((IItemHandler)this.getCitizen().getInventory(), Items.field_185159_cQ));
            worker.func_184598_c(Hand.OFF_HAND);
            ItemStack shieldStack = worker.getInventoryCitizen().getHeldItem(Hand.OFF_HAND);
            CompoundNBT nbt = shieldStack.func_190925_c("BlockEntityTag");
            nbt.func_218657_a("Patterns", (INBT)worker.getCitizenColonyHandler().getColony().getColonyFlag());
            worker.decreaseSaturationForContinuousAction();
            return true;
        }
        return super.ignoresDamage(damageSource);
    }
}

